//+------------------------------------------------------------------+
//|                                                    variables.mq4 |
//|                                            Zoltan Laszlo Ferenci |
//|                              http://www.metatraderprogrammer.com |
//+------------------------------------------------------------------+
#property copyright "Zoltan Laszlo Ferenci"
#property link      "http://www.metatraderprogrammer.com"

bool initalized=false;

string symbol;
double point;
int digits;
double ticksize;
int stoplevel;
double tickvalue;
double minlot, lotstep, maxlot;
int stoplevel_inticks;
double ticksize_inpoints;
double lotvalue;

datetime ticktime;
double bid, ask;
double force_bid=0, force_ask=0;
int spread;
int spread_inticks;
int minsl, mintp;
int orderstotal;

datetime lasttick = 0;
bool isfirsttick = false;

double fractional_treshold = 50000;

double lotroundup = 1;
bool roundup_to_minlot = false;
int lot_extradigits = 0;

string initerror = "variables.mqh has not been initalized!";
string priceiniterror = "variables.mqh has not been initalized at actual tick!";

void variables_init(string in_symbol = "") //tested
{
   initalized = true;
   if (in_symbol == "")
   {
      symbol = Symbol();
      point = Point;
      digits = Digits;
   }
   else
   {
      symbol = in_symbol;
      point = MarketInfo(symbol,MODE_POINT);
      digits = MarketInfo(symbol,MODE_DIGITS);
   }
   stoplevel = MarketInfo(symbol,MODE_STOPLEVEL); //in points
   tickvalue = MarketInfo(symbol,MODE_TICKVALUE); //in deposit currency
   ticksize = MarketInfo(symbol,MODE_TICKSIZE);
   minlot = MarketInfo(symbol,MODE_MINLOT);
   lotstep = MarketInfo(symbol,MODE_LOTSTEP);
   maxlot = MarketInfo(symbol,MODE_MAXLOT);
   if (ticksize == 0) ticksize = point;
   ticksize_inpoints = ticksize/point;
   stoplevel_inticks = MathRound(stoplevel/ticksize_inpoints);
   lotvalue = tickvalue/ticksize; //in deposit currency
   mintp = stoplevel_inticks;
}

void variables_priceinit(string alerttext = "")
{
   initalized_alert(alerttext);

   RefreshRates();
   ticktime = MarketInfo(symbol,MODE_TIME);
   
   if (force_bid > 0) bid = force_bid; else bid = MarketInfo(symbol,MODE_BID);
   if (force_ask > 0) ask = force_ask; else ask = MarketInfo(symbol,MODE_ASK);

   spread = MarketInfo(symbol,MODE_SPREAD);
   spread_inticks = MathRound(spread/ticksize_inpoints);
   minsl = spread_inticks + stoplevel_inticks;
   orderstotal = OrdersTotal();
}

void forceprice(double price_bid, double price_ask)
{
   force_bid = price_bid;
   force_ask = price_ask;
}

void clear_forceprice()
{
   force_bid = 0;
   force_ask = 0;
}

void variables_refresh()
{
   variables_priceinit();
}

bool isfractional()
{
   priceinitalized_check("isfractional: ");
   if (bid/ticksize > fractional_treshold)
      return(true);

   return(false);
}

bool isdoublefractional()
{
   priceinitalized_check("isfractional: ");
   if (bid/ticksize > fractional_treshold*10)
      return(true);

   return(false);
}

int fract(int& num)
{
   num *= 10;
   return(num);
}

int fractd(double& num)
{
   num *= 10;
   return(num);
}

void variables_fullinit(string symbol = "")
{
   variables_init(symbol);
   variables_priceinit();
}

bool priceinitalized()
{
   if (initalized && (ticktime == MarketInfo(symbol,MODE_TIME)))
      return(true);
   else
      return(false);
}

bool priceinitalized_alert(string text = "") //tested
{
   if (priceinitalized())
      return(true);
   
   Alert(text,priceiniterror);
   return(false);
}

bool priceinitalized_check(string alerttext="") //tested
{
   if (priceinitalized())
      return(true);
   
   variables_priceinit(alerttext);
   return(false);
}

bool initalized_alert(string text = "") //tested
{
   if (initalized)
      return(true);
   
   Alert(text,initerror);
   return(false);
}

int inticks(double price)
{
   return(MathRound(price/ticksize));
}

double inticksd(double price)
{
   return(price/ticksize);
}

double priceround(double price)
{
   return(inticks(price)*ticksize);
}

double lotround(double lotreq)
{
   double _lotstep = lotstep/MathPow(10,lot_extradigits);
   double lotquotient = lotreq/_lotstep;
   
   double lotwhole = MathRound(lotquotient);
   if (lotwhole > lotquotient)
      lotwhole--;
   double lotdecimal = lotquotient-lotwhole;
   if (lotdecimal >= lotroundup)
      lotwhole++;

   double lot = lotwhole*_lotstep;
   if (lot < minlot && lot_extradigits == 0)
   {
      if (roundup_to_minlot)
         lot = minlot;
      else
         lot = 0;
   }
   if (lot > maxlot)
      lot = maxlot;
   return(lot);
}

bool compare(double price1, double price2)
{
   if (inticks(price1) == inticks(price2))
      return(true);
   else
      return(false);
}

bool larger(double price1, double price2)
{
   if (inticks(price1) > inticks(price2))
      return(true);
   else
      return(false);
}

bool smaller(double price1, double price2)
{
   if (inticks(price1) < inticks(price2))
      return(true);
   else
      return(false);
}

bool larger_oreq(double price1, double price2)
{
   if (inticks(price1) >= inticks(price2))
      return(true);
   else
      return(false);
}

bool smaller_oreq(double price1, double price2)
{
   if (inticks(price1) <= inticks(price2))
      return(true);
   else
      return(false);
}

bool isfirsttick(int timeframe = 0)
{
   priceinitalized_check("isfirsttick: ");
   datetime bartime = iTime(symbol,timeframe,0);
   if (bartime == lasttick)
   {
      isfirsttick = false;
      return(isfirsttick);
   }
   else
   {
      lasttick = bartime;
      isfirsttick = true;
      return(isfirsttick);
   }
}

bool isfirsttick_var(datetime& lasttickvar, int timeframe = 0)
{
   priceinitalized_check("isfirsttick: ");
   datetime bartime = iTime(symbol,timeframe,0);
   if (bartime == lasttickvar)
   {
      return(false);
   }
   else
   {
      lasttickvar = bartime;
      return(true);
   }
}

int shiftconvert(int bar, int timeframe1, int timeframe2)
{
   return(iBarShift(symbol,timeframe2,iTime(symbol,timeframe1,bar)));
}